//---------------------------------------------------------------------------

#include <vcl.h>
#include "Message_Form.h"
#include "MultiLanguage.h"
#pragma hdrstop
//---------------------------------------------------------------------------
USEFORM("Main_Form.cpp", MainForm);
USEFORM("BackupProcess_Form.cpp", BackupProcessForm);
USEFORM("RestoreProcess_Form.cpp", RestoreProcessForm);
USEFORM("Message_Form.cpp", MessageForm); /* TTntForm: File Type */
//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	try
	{
		const char mutexname[] = "vm_data_management";
		HANDLE hMutex = NULL;

    AnsiString RootPath;
    RootPath = ExtractFileDir(Application->ExeName);

		hMutex = OpenMutexA(SYNCHRONIZE, false, mutexname);
		if (hMutex==NULL)
		{
      if(!LoadFromFile(RootPath + "\\Env\\TLanguage.dat"))
      {
        CloseHandle(hMutex);
        ShowMessageW("Cannot read Language.dat");
      }
      else
      {
        SetDefaultLocaleInfo();
        GetStringData();
        Free_StringStruct();
      }
			hMutex = CreateMutexA(NULL, true, mutexname);
		}
		else
		{
			CloseHandle(hMutex);
			ShowMessageFA(BACKUPUTIL_CAPTION_25);
			return 0;
		}
		Application->Initialize();
		Application->CreateForm(__classid(TMainForm), &MainForm);
    Application->Run();
	}
	catch (Exception &exception)
	{
		Application->ShowException(&exception);
	}
	catch (...)
	{
		try
		{
			throw Exception("");
		}
		catch (Exception &exception)
		{
			Application->ShowException(&exception);
		}
	}
	return 0;
}
//---------------------------------------------------------------------------
